/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplication;

import datasource.DataSource;
import datasource.FileDataSource;
import java.util.List;
import java.util.stream.Stream;
import products.*;
import static salesApplication.CompanyInfo.*;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class OtherStreamingOperations {

    //data to illustrate flatMap
    static String largeText
            = "This is a large amount of text\n"
            + "It contains several lines of code\n"
            + "Each line of code contains lots of words\n"
            + "We want to process this text line by line and word by word.";
    static String[] lines = largeText.split("\n");
    static Stream<String> lineStream = Stream.of(lines);

    public static void main(String[] args) {
        DataSource ds = new FileDataSource();
        PriceList demo = ds.retrieveList("Demo");
        List<Item> demoList = demo.getList();

        System.out.println("Discounted Notepads");
        demoList.stream()
                .filter(p -> (p instanceof Notepad))
                .map(clearanceSale)
                .forEach(p -> System.out.println(p));
    }
}
